% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boys7482-data.R
\docType{data}
\name{boys7482}
\alias{boys7482}
\title{Anthropometric measurements for Dutch boys (1997 reference)}
\format{
A data frame with 7,482 rows and 9 variables:
\describe{
\item{age}{Decimal age in years ranging from birth to 21.}
\item{hgt}{Standing height in centimetres.}
\item{wgt}{Body weight recorded in kilograms.}
\item{bmi}{Body mass index.}
\item{hc}{Head circumference in centimetres.}
\item{gen}{Ordered factor describing genital Tanner stage (G1--G5).}
\item{phb}{Ordered factor indicating pubic hair stage (P1--P6).}
\item{tv}{Testicular volume in millilitres.}
\item{reg}{Region of residence (north, east, west, south, city).}
}
}
\source{
Fredriks, A. M., van Buuren, S., Burgmeijer, R. J., Meulmeester, J. F.,
Beuker, R. J., Brugman, E., Roede, M. J., Verloove-Vanhorick, S. P., & Wit,
J. M. (2000). Continuing positive secular growth change in The Netherlands
1955-1997. \emph{Pediatric Research}, 47, 316-323.

Fredriks, A. M., van Buuren, S., Wit, J. M., & Verloove-Vanhorick, S. P.
(2000). Body index measurements in 1996-97 compared with 1980. \emph{Archives of
Disease in Childhood}, 82, 107-112.
}
\description{
Cross-sectional anthropometric records for 7,482 Dutch boys aged 0 to 21
years that were used to construct the 1997 Dutch growth references. The
dataset stores standard auxological indicators together with puberty and
regional classification variables.
}
\details{
The table combines the complete cross-sectional sample of Dutch boys aged
0--21 years that formed the basis of the Dutch 1997 growth references. Tanner
stage variables are stored as ordered factors, while the region indicator is a
nominal factor.
}
\examples{
data(boys7482)
str(boys7482)
}
\references{
Stef van Buuren (2012).
}
\keyword{datasets}
