% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_mixed_missingness.R
\name{simulate_mixed_missingness}
\alias{simulate_mixed_missingness}
\title{Simulate a Gaussian Mixture Dataset with a Mixed-Missingness Mechanism (MAR + MCAR)}
\usage{
simulate_mixed_missingness(
  n = 500,
  pi,
  mu,
  sigma,
  xi0 = 2,
  xi1 = 3,
  alpha = 0.1,
  seed_id = 123
)
}
\arguments{
\item{n}{Integer; sample size.}

\item{pi}{Numeric vector; mixing proportions (sum to 1).}

\item{mu}{Matrix (p x K); component means, columns = components.}

\item{sigma}{Array (p x p x K); component covariance matrices.}

\item{xi0}{Numeric; MAR logit intercept.}

\item{xi1}{Numeric; MAR logit slope on entropy.}

\item{alpha}{Numeric in \code{[0,1]}; MCAR rate applied within both MAR and observed groups.}

\item{seed_id}{Integer; seed passed to rmix() (your generator).}
}
\value{
A list with:
\itemize{
\item data: data.frame with columns x1..xp, en, missing, label, truth
\item true_setup: list(pi, mu, sigma)
\item groups: list(mar_group, obs_group, mcar_in_mar, mcar_in_obs)
\item probs: vector prob_mar
\item raw: original rmix output \code{dat} augmented with en and labels
}
}
\description{
Simulate a Gaussian Mixture Dataset with a Mixed-Missingness Mechanism (MAR + MCAR)
}
\details{
Requires user-provided functions:
\itemize{
\item rmix(n, pi, mu, sigma, seed_number)
\item get_entropy(dat, n, p, g, paralist)
}

Missingness mechanism codes:
\itemize{
\item 0 = fully observed
\item 1 = MCAR
\item 2 = MAR (entropy-based)
}
}
