% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FERSInt.R
\name{FERSInt}
\alias{FERSInt}
\title{P values for shapes obtained from semi-parametric shape-restricted fixed effect regression splines with factor-by-curve interaction.}
\usage{
FERSInt(
  y,
  xExp,
  xMed,
  xConf = NULL,
  dataset,
  knotType = 2,
  preKnot = NULL,
  nBasis = 5,
  nIter
)
}
\arguments{
\item{y}{The name of the outcome.}

\item{xExp}{The name of the exposure (must be a binary variable).}

\item{xMed}{The name of the mediator (must be a continuous variable).}

\item{xConf}{The name vector of the confounders.}

\item{dataset}{A data frame.}

\item{knotType}{The knot type: 1=equal-spaced, 2=quantile, 3=pre-specified.}

\item{preKnot}{The pre-specified knots.}

\item{nBasis}{The number of bases.}

\item{nIter}{The number of iterations.}
}
\value{
A list of weights of beta distribution and p-values for both exposure groups.
}
\description{
P values for shapes obtained from semi-parametric shape-restricted fixed effect regression splines with factor-by-curve interaction.
}
\note{
This function has not been validated through simulation studies. Please use with caution.
shape <- FERSInt(y = "ySim", xExp = "pesticide1", xMed = "hormone",
xConf = c("pesticide1", "age", "invwt", "race2", "race3", "race4", "race5",
"season2", "season3", "season4", "smoking1", "ovum1", "diabetes1"),
dataset = data.sim.fixed.int, nBasis = 5, nIter = 50)
shape
}
