% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression_outcome_scb.R
\name{check_and_align_vars}
\alias{check_and_align_vars}
\title{Validate and align types/levels between training data and prediction grid}
\usage{
check_and_align_vars(df_fit, grid_df, model_vars = NULL, grid_boot = FALSE)
}
\arguments{
\item{df_fit}{A data frame used for model fitting. Character columns will be
coerced to factors before alignment.}

\item{grid_df}{A data frame of covariate settings (newdata) at which
predictions/SCBs are to be evaluated.}

\item{model_vars}{A vector contained all the interested columns that appear
in \code{df_fit}. Only those variables are aligned in \code{grid_df};
other columns are left unchanged. Default is NULL.}

\item{grid_boot}{A logic value for whether the function is for constructing
\code{grid_df_boot} or not.}
}
\value{
\item{grid_df}{The prediction grid with variables aligned to \code{df_fit}.}
}
\description{
Ensures that variables in \code{grid_df} are type-compatible with \code{df_fit} and that
factor (including ordered factor) levels are aligned to those used during model
fitting. Character columns in \code{df_fit} are first coerced to factors. For any
factor/ordered variable, \code{grid_df} is coerced to the same type and levels; any
unseen levels in \code{grid_df} will trigger an error.
}
\examples{
# Used internally by SCB_linear_outcome, SCB_logistic_outcome

}
\keyword{internal}
