% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vs_sintax.R
\name{vs_sintax}
\alias{vs_sintax}
\alias{sintax}
\alias{classify}
\title{Taxonomic classification using the Sintax algorithm}
\usage{
vs_sintax(
  fasta_input,
  database,
  outfile = NULL,
  cutoff = 0,
  strand = "plus",
  sintax_random = TRUE,
  randseed = NULL,
  logfile = NULL,
  threads = 1,
  vsearch_options = NULL,
  tmpdir = NULL
)
}
\arguments{
\item{fasta_input}{(Required). A FASTA file path or a FASTA object with reads
to classify, see \emph{Details}.}

\item{database}{(Required). A FASTA file path or a FASTA object containing
the reference database in FASTA format. The sequences need to be annotated
with taxonomy, see \emph{Details}.}

\item{outfile}{(Optional). Name of the output file. If \code{NULL} (default),
results are returned as a data.frame.}

\item{cutoff}{(Optional). Minimum level of bootstrap support (0.0-1.0) for
the classifications. Defaults to \code{0.0}.}

\item{strand}{(Optional). Specifies which strand to consider when comparing
sequences. Can be either \code{"plus"} (default) or \code{"both"}.}

\item{sintax_random}{(Optional). If \code{TRUE} (default), the Sintax
algorithm breaks ties between sequences with equally many kmer matches by a
random draw.}

\item{randseed}{(Optional). Seed for the random number generator used in the
Sintax algorithm. Defaults to \code{NULL}.}

\item{logfile}{(Optional). Name of the log file to capture messages from
\code{VSEARCH}. If \code{NULL} (default), no log file is created.}

\item{threads}{(Optional). Number of computational threads to be used by
\code{VSEARCH}. Defaults to \code{1}.}

\item{vsearch_options}{(Optional). A character string of additional arguments
to pass to \code{VSEARCH}. Defaults to \code{NULL}. See \emph{Details}.}

\item{tmpdir}{(Optional). Path to the directory where temporary files should
be written when tables are used as input or output. Defaults to
\code{NULL}, which resolves to the session-specific temporary directory
(\code{tempdir()}).}
}
\value{
If \code{outfile} is \code{NULL} a data.frame is returned. If it
contains a file name (text) the data.frame is written to that file with
tab-separated columns.

The data.frame contains the classification results for each input sequence.
Both the \code{Header} and \code{Sequence} columns of \code{fasta_input} are
copied into this table, and in addition are also the columns for each rank.
The ranks depend on the database file used, but are typically domain, phylum,
class, order,family, genus and species. For each classification is also a
bootstrap support score. These are in separate columns with corresponding
names, i.e. domain_score, phylum_score, etc.
}
\description{
\code{vs_sintax} classifies sequences using the Sintax algorithm
implemented in \code{VSEARCH}.
}
\details{
The sequences in the input file are classified according to the
Sintax algorithm, using \code{VSEARCH}, see
\url{https://www.biorxiv.org/content/10.1101/074161v1}.

\code{fasta_input} can either be a file path to a FASTA file or a
FASTA object. FASTA objects are tibbles that contain the columns
\code{Header} and \code{Sequence}, see \code{\link[microseq]{readFasta}}.

\code{database} can either be a file path to a FASTA file or a
FASTA object. FASTA objects are tibbles that contain the
columns \code{Header} and \code{Sequence}, see
\code{\link[microseq]{readFasta}}. The \code{Header} texts of this file must
follow the sintax-pattern, see \code{\link{make_sintax_db}}.

\code{vsearch_options} allows users to pass additional command-line arguments
to \code{VSEARCH} that are not directly supported by this function. Refer to
the \code{VSEARCH} manual for more details.
}
\examples{
\dontrun{
# Example files
db.file <- file.path(file.path(path.package("Rsearch"), "extdata"),
                     "sintax_db.fasta")
fasta.file <- file.path(file.path(path.package("Rsearch"), "extdata"),
                     "small.fasta")

tax.tbl <- vs_sintax(fasta_input = fasta.file, database = db.file)
View(tax.tbl)
}


}
\references{
\url{https://github.com/torognes/vsearch}
\url{https://www.biorxiv.org/content/10.1101/074161v1}
}
