% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vsearch.R
\name{set_vsearch_executable}
\alias{set_vsearch_executable}
\title{Set the VSEARCH executable}
\usage{
set_vsearch_executable(vsearch_executable)
}
\arguments{
\item{vsearch_executable}{(Required). Full path to the VSEARCH executable on
your computer. See \emph{Details} for more information on how to install
\code{VSEARCH}.}
}
\value{
Nothing is returned, but the option \code{Rsearch.vsearch_executable}
is updated. The string is also saved to a file for later R sessions, i.e. you
only need to update this once (or if you change how you run/install VSEARCH).
}
\description{
\code{set_vsearch_executable} specifies the valid command to
invoke \code{VSEARCH}.
}
\details{
Use this function to change the command used to invoke the external
software VSEARCH on this computer. When the \code{Rsearch} package is
installed this command is by default just \code{"vsearch"}.

If you have a windows computer and have copied the binary \code{vsearch.exe}
to the folder C:/Documents/ on your computer, you update R with this
information by  \code{set_vsearch_executable("C:/Documents/vsearch")}.

You may use the function \code{\link{vsearch}} to test if the command is
valid.

Visit \url{https://github.com/CassandraHjo/Rsearch} for more information on
how to install \code{VSEARCH}.
}
\seealso{
\code{\link{vsearch}}.
}
