% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Barabasi.R
\name{Barabasi.B_eff}
\alias{Barabasi.B_eff}
\title{Average the product of the outgoing and incoming degrees of nodes}
\usage{
Barabasi.B_eff(M)
}
\arguments{
\item{M}{Adjacency matrix of the network that describes the system}
}
\value{
A numeric value describing the Beta_eff described by Barabasi.
}
\description{
This is the average of the outgoing/incoming nodes, described by Barabasi in his paper 'Universal resilience patterns in complex networks'.
}
\examples{
\donttest{
   node_file <- system.file("extdata", "IL17.nodes.csv", package = "Rato")
   edge_file <- system.file("extdata", "IL17.edges.csv", package = "Rato")
   g <- Rato::graph.from.csv(node_file, edge_file, sep=",", header=TRUE)
 
   initial_parameters <- function(M){
     initial_params <- list('f' = 1, 'h' = 2, 'B' = 0.1, 'Beta' = Rato::Barabasi.B_eff(M))
     return(initial_params)
   }
   
   update_parameters <- function(params){
     M <- params$M
     params$Beta <- Rato::Barabasi.B_eff(M)
     return(params)
   }
 
   Rato::node.removal.thread( system = Rato::Michaelis.Menten.Fast
                            , M = g$M
                            , x0 = Rato::Barabasi.X_eff(g$M, g$initial_values)
                            , initial_params = initial_parameters
                            , update_params = update_parameters
                            , to.numeric = TRUE)

}
}
