% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ajouter_label_ndm_function.R
\name{ajouter_label_ndm}
\alias{ajouter_label_ndm}
\title{Add "n (dm ; \%dm)" to Variable Labels}
\usage{
ajouter_label_ndm(data, col_to_skip = NULL)
}
\arguments{
\item{data}{A data frame containing the dataset whose variable labels need to be updated.}

\item{col_to_skip}{A column to skip when adding \code{"n (dm ; \%dm)"}. Default is \code{NULL}.}
}
\value{
A data frame with updated variable labels.
}
\description{
This function appends the text "n (dm ; \%dm)" to the labels of all variables in a dataset.
It uses the \code{labelled} package to modify and update variable labels in-place.
}
\details{
The function iterates over all columns in the dataset and performs the following steps:
\enumerate{
\item Retrieves the current label of each variable using \code{labelled::var_label}.
\item Creates a new label by appending the text \code{"n (dm ; \%dm)"} to the existing label.
\item Updates the variable's label using \code{labelled::set_variable_labels}.
}

This is useful when preparing a dataset for descriptive analysis, where it is helpful to display
missing data statistics (\code{n}, \code{dm}, and \verb{\%dm}) alongside variable labels in summary tables.
}
\examples{
# Example usage:
library(labelled)

# Create a sample dataset
data <- data.frame(
  var1 = c(1, 2, NA),
  var2 = c("A", "B", NA)
)

# Assign initial labels
data <- labelled::set_variable_labels(
  data,
  var1 = "Variable 1",
  var2 = "Variable 2"
)

# Add "n (dm ; \%dm)" to labels
data <- ajouter_label_ndm(data)

# Check updated labels
labelled::var_label(data)

}
