% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skewnorm2.R
\name{skewnorm2}
\alias{skewnorm2}
\alias{dskewnorm2}
\alias{pskewnorm2}
\alias{qskewnorm2}
\alias{rskewnorm2}
\title{Reparameterised skew normal distribution}
\usage{
dskewnorm2(x, mean = 0, sd = 1, alpha = 0, log = FALSE)

pskewnorm2(q, mean = 0, sd = 1, alpha = 0, ...)

qskewnorm2(p, mean = 0, sd = 1, alpha = 0, ...)

rskewnorm2(n, mean = 0, sd = 1, alpha = 0)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{mean}{mean parameter}

\item{sd}{standard deviation, must be positive.}

\item{alpha}{skewness parameter, +/- \code{Inf} is allowed.}

\item{log}{logical; if \code{TRUE}, probabilities/ densities \eqn{p} are returned as \eqn{\log(p)}.}

\item{...}{additional parameters to be passed to the \code{sn} package functions for \code{pskewnorm} and \code{qskewnorm}.}

\item{p}{vector of probabilities}

\item{n}{number of random values to return}
}
\value{
\code{dskewnorm2} gives the density, \code{pskewnorm2} gives the distribution function, \code{qskewnorm2} gives the quantile function, and \code{rskewnorm2} generates random deviates.
}
\description{
Density, distribution function, quantile function and random generation for
the skew normal distribution reparameterised in terms of mean, standard deviation and skew magnitude
}
\details{
This implementation of \code{dskewnorm2} allows for automatic differentiation with \code{RTMB} while the other functions are imported from the \code{sn} package.
}
\examples{
# alpha is skew parameter
x <- rskewnorm2(1, alpha = 1)
d <- dskewnorm2(x, alpha = 1)
p <- pskewnorm2(x, alpha = 1)
q <- qskewnorm2(p, alpha = 1)
}
