% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd_transform.R
\name{rd_transform}
\alias{rd_transform}
\title{Transformation of the Raw Data}
\usage{
rd_transform(
  project = NULL,
  data = NULL,
  dic = NULL,
  event_form = NULL,
  checkbox_labels = c("No", "Yes"),
  na_logic = "none",
  exclude_recalc = NULL,
  exclude_factor = NULL,
  delete_vars = NULL,
  delete_pattern = NULL,
  final_format = "raw",
  which_event = NULL,
  which_form = NULL,
  wide = NULL
)
}
\arguments{
\item{project}{A list containing the REDCap data, dictionary, and event mapping (expected \code{redcap_data()} output). Overrides \code{data}, \code{dic}, and \code{event_form}.}

\item{data}{A \code{data.frame} or \code{tibble} with the REDCap dataset.}

\item{dic}{A \code{data.frame} with the REDCap dictionary.}

\item{event_form}{Only applicable for longitudinal projects (presence of events). Event-to-form mapping for longitudinal projects.}

\item{checkbox_labels}{Character vector of length 2 for labels of unchecked/checked values. Default: \code{c("No", "Yes")}.}

\item{na_logic}{Controls how missing values are set based on the branching logic of a checkbox. Must be one of \code{"none"} (do nothing), \code{"missing"} (set to \code{NA} only when the logic evaluation is \code{NA}), or \code{"eval"} (set to \code{NA} when the logic evaluates to \code{FALSE}). Defaults to \code{"none"}.}

\item{exclude_recalc}{Optional. Character vector of field names to exclude from recalculation.}

\item{exclude_factor}{Optional character vector of variable names (use original names \strong{without} the \code{.factor} suffix) to exclude from conversion.}

\item{delete_vars}{Optional. A character vector of variable names to remove from both the dataset and dictionary.}

\item{delete_pattern}{Optional. A character vector of regular expression patterns. Variables matching these patterns will be removed from the dataset and dictionary.}

\item{final_format}{Character string indicating the final format of the data. Options are \code{raw}, \code{by_event} or \code{by_form}. \code{raw} (default) returns the transformed data in its original structure, \code{by_event} returns it as a nested data frame by event, and \code{by_form} returns it as a nested data frame by form.}

\item{which_event}{Character. If \code{final_format = "by_event"}, return only this event.}

\item{which_form}{Character. If \code{final_format = "by_form"}, return only this form.}

\item{wide}{Logical. If \code{TRUE} (for form-based splits), repeated instances are returned in wide format. Defaults to \code{FALSE}.}
}
\value{
A list with elements:
\describe{
\item{data}{Transformed data (data.frame or nested list when split).}
\item{dictionary}{Updated dictionary data.frame.}
\item{event_form}{Event–form mapping (if applicable).}
\item{results}{Character summary of transformation steps performed.}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Transforms the raw REDCap data read by the \code{redcap_data} function. The function runs in one-step pipeline all functions dedicated to processing the data and returns the transformed data and dictionary, along with a summary of each step done.
}
\examples{
# Minimal usage (project object or data + dictionary)
trans <- rd_transform(covican)

# Custom checkbox labels
trans <- rd_transform(covican,
                      checkbox_labels = c("Not present", "Present"))

# Return only a single form (wide)
trans <- rd_transform(covican,
                      final_format = "by_form",
                      which_form = "laboratory_findings",
                      wide = TRUE)

}
