% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HodgesLehmann.R
\name{HodgesLehmann}
\alias{HodgesLehmann}
\title{Hodges-Lehmann (1952) Modification of Bayes Priors for Compound Decisions
 
 Given a prior \eqn{G} find a modified prior \eqn{f} that bounds  minimax risk.}
\usage{
HodgesLehmann(grid, G, alpha, type = "Huber", ...)
}
\arguments{
\item{grid}{grid on which to interpolate}

\item{G}{initial prior}

\item{alpha}{contamination proportion}

\item{type}{either "Huber" or "Mallows"}

\item{...}{other arguments to be passed to Mosek.}
}
\value{
An object of class density with solution
}
\description{
There are two variants both  minimize Fisher information for location 
 via conic optimization:
  \deqn{\min \sum \frac{(f_{i+1}-f_i )^2}{( f_{i+1}+f_i )/2} = \sum \frac{u_i^2}{v_i/2} \approx I(F)}
  \deqn{\Leftrightarrow  \quad  \min \sum w_i \;  \mbox{s.t.} \;  u_i^2  \leq 2 v_i w_i}
 Huber Variant as proposed in Efron and Morris (1971) imposing constraint
 	\deqn{f(x) = \alpha \Phi * G + (1-\alpha) h(x)} 
 Mallows Variant as proposed in Bickel (1983) imposing constraints
  	\deqn{f(x) = \alpha \Phi * G + (1-\alpha) h(x), \; h(x) = \Phi * H}
 N.B. When the grid is not equispaced, one would have to include grid spacings.
}
\references{
Bickel, P. (1983), Minimax estimation of the mean of a normal distribution subject
to doing well at a point, in M. H. Rizvi, J. S. Rustagi & D. Siegmund, eds,
‘Recent Advances in Statistics: Papers in Honor of Herman Chernoff on his
Sixtieth Birthday’, Academic Press, pp. 511–528

Efron, B. & Morris, C. (1971), ‘Limiting the risk of Bayes and empirical Bayes
estimators part I: the Bayes case’, Journal of the American Statistical Association
66, 807–815.

Hodges, J. L. & Lehmann, E. L. (1952), ‘The use of previous experience in reaching
statistical decisions’, The Annals of Mathematical Statistics pp. 396–407.

Huber, P. (1964), ‘Robust estimation of a location parameter’, The Annals of
Mathematical Statistics pp. 73–101.

Huber, P. (1974) "Fisher Information and Spline Interpolation." 
Ann. Statist. 2 (5) 1029 - 1033,  

Mallows, C. (1978), ‘Problem 78-4, minimizing an integral’, SIAM Review 20, 183– 183.
}
\seealso{
HuberSpline
}
\author{
R. Koenker and J. Gu
}
\keyword{nonparametric}
