% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlwin2bugs.R
\name{mlwin2bugs}
\alias{mlwin2bugs}
\title{This function captures output files from MLwiN for estimation in
WinBUGS/OpenBUGS.}
\usage{
mlwin2bugs(
  datafile,
  initfiles,
  modelfile,
  parameters = NULL,
  n.chains = 1,
  n.iter = 5500,
  n.burnin = 500,
  n.thin = 1,
  debug = FALSE,
  bugs.directory = NULL,
  bugsWorkingDir = tempdir(),
  OpenBugs = FALSE,
  cleanBugsWorkingDir = FALSE,
  seed = NULL
)
}
\arguments{
\item{datafile}{A file name where the BUGS data file will be saved in
.txt format.}

\item{initfiles}{A list of file names where the BUGS initial values will
be saved in .txt format.}

\item{modelfile}{A file name where the BUGS model will be saved in .txt
format.}

\item{parameters}{A vector of strings specifying coefficients to be
monitored.}

\item{n.chains}{The number of chains to be monitored.}

\item{n.iter}{The number of iterations for each chain}

\item{n.burnin}{The length of burn-in for each chain}

\item{n.thin}{Thinning rate}

\item{debug}{A logical value indicating whether (\code{TRUE}) or not
(\code{FALSE}; the default) to close the BUGS window after completion of the
model run}

\item{bugs.directory}{The full path of location where WinBUGS is installed 
(ignored if OpenBugs is \code{TRUE}).}

\item{bugsWorkingDir}{A directory where all the intermediate files are to be
stored; defaults to \code{tempdir()}.}

\item{OpenBugs}{If \code{TRUE}, OpenBUGS is used, if \code{FALSE} (the
default) WinBUGS is used.}

\item{cleanBugsWorkingDir}{If \code{TRUE}, the generated files will be
removed from the \code{bugsWorkingDir}; defaults to \code{FALSE}.}

\item{seed}{An integer specifying the random seed.}
}
\value{
Returns an \code{\link[coda]{mcmc}} object.
}
\description{
This function allows R to call WinBUGS using the output files from MLwiN.
This function uses functionalities in the \code{\link[R2WinBUGS]{R2WinBUGS-package}}
package.
}
\seealso{
\code{\link{runMLwiN}},\code{\link[R2WinBUGS]{bugs}}
}
\author{
Zhang, Z., Charlton, C.M.J., Parker, R.M.A., Leckie, G., and Browne,
W.J. (2016) Centre for Multilevel Modelling, University of Bristol.
}
