% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{interpolate_NAs}
\alias{interpolate_NAs}
\title{Interpolation for missing data.}
\usage{
interpolate_NAs(data = data, Method = "linear", XandY = TRUE, MinData = 2)
}
\arguments{
\item{data}{A data frame object created from \code{auto_cleanup}.}

\item{Method}{A character string indicating type of interpolation ("linear"
or "spline") as implemented in \link[zoo]{na.approx}.}

\item{XandY}{A logical specifying if interpolation should also be done on
gaze coordinates}

\item{MinData}{A number indicating the minimum number of data points
required in order for interpolation to be applied to the event.}
}
\value{
An object of type data table as described in \link[tibble]{tibble}.
}
\description{
\code{interpolate_NAs} performs interpolation of missing data for
the pupil and gaze coordinates (if desired).
}
\examples{
# Load example data
data("Pupilex4")

dat <- interpolate_NAs(Pupilex4, Method = "linear",
                       XandY = TRUE, MinData = 2)

# Please see the vignettes for detailed example usage.
# vignette("PupilPre_Interpolation_and_Filtering", package="PupilPre")

}
