% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_comparing_indices.R
\name{compare_indices_df}
\alias{compare_indices_df}
\title{A function for graphical comparison of price indices}
\usage{
compare_indices_df(
  data,
  names = colnames(data)[2:length(colnames(data))],
  date_breaks = "1 month"
)
}
\arguments{
\item{data}{The user's data frame with price index values. It must contain columns: \code{time} (as character in format: year-month, e.g. '2020-12') and columns with index values.}

\item{names}{A vector of strings indicating names of indices which are to be used in the figure's legend.}

\item{date_breaks}{A string giving the distance between breaks on the X axis like "1 month" (default value) or "4 months".}
}
\value{
This function returns a figure with plots of previously calculated indices (together with dates on X-axis and a corresponding legend). Indices must be provided as a data frame, where the the first column must includes dates limited to the year and month (e.g.: "2020-04").
}
\description{
This function returns a figure with plots of selected price indices.
}
\examples{
\donttest{df<-price_indices(milk, start = "2018-12", end = "2019-12", 
formula=c("laspeyres", "fisher"), interval = TRUE)}
\donttest{compare_indices_df(df)}
}
