% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize_plate.R
\name{view_plate}
\alias{view_plate}
\title{Visualize Plate Layout (Heatmap)}
\usage{
view_plate(data, fill_var = "Ct", interactive = FALSE)
}
\arguments{
\item{data}{The dataframe output from import_plate().}

\item{fill_var}{The column to color the wells by (e.g., "Ct", "Sample", "Gene").}

\item{interactive}{If TRUE, returns a plotly interactive graph. If FALSE, returns static ggplot.}
}
\value{
A ggplot object or plotly object.
}
\description{
Creates a physical map of the 96-well plate colored by Ct value or Sample.
}
\examples{
# Create dummy data representing a partial plate
dummy_data <- data.frame(
  Well = c("A1", "A2", "A3", "B1", "B2", "B3"),
  Ct = c(20, 20.5, 19.8, 25, 24.5, 26),
  Sample = c(rep("Control", 3), rep("Treated", 3)),
  Gene = "GAPDH"
)

# View static heatmap
view_plate(dummy_data, fill_var = "Ct")

# View interactive heatmap (if library plotly is available)
view_plate(dummy_data, fill_var = "Sample", interactive = FALSE)
}
