% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExternalValidatePlp.R
\name{createValidationSettings}
\alias{createValidationSettings}
\title{createValidationSettings define optional settings for performing external validation}
\usage{
createValidationSettings(recalibrate = NULL, runCovariateSummary = TRUE)
}
\arguments{
\item{recalibrate}{A vector of characters specifying the recalibration method to apply}

\item{runCovariateSummary}{Whether to run the covariate summary for the validation data}
}
\value{
A setting object of class \code{validationSettings} containing a list of settings for externalValidatePlp
}
\description{
This function creates the settings required by externalValidatePlp
}
\details{
Users need to specify whether they want to sample or recalibate when performing external validation
}
\examples{
# do weak recalibration and don't run covariate summary
createValidationSettings(recalibrate = "weakRecalibration", 
                         runCovariateSummary = FALSE)

}
