% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/U04-censoring-scores.R
\name{estimate_censoring_score_cox}
\alias{estimate_censoring_score_cox}
\title{Estimate Censoring Scores Using Cox Regression}
\usage{
estimate_censoring_score_cox(
  data,
  time_var,
  treatment_var,
  formula,
  control = list(),
  ties = "efron"
)
}
\arguments{
\item{data}{Data frame.}

\item{time_var}{Name of time variable.}

\item{treatment_var}{Name of treatment variable.}

\item{formula}{Censoring model formula. Use \code{Surv(time, censor_indicator) ~ X1 + X2}
where \code{censor_indicator = 1} indicates censoring. If event is coded
canonically (event=1, censored=0), use \code{I(1-event)}. Otherwise, use
the appropriate transformation. Treatment is automatically removed if included.}

\item{control}{Control parameters for \code{coxph()}. Default \code{list()}.}

\item{ties}{Tie handling method. Default "efron".}
}
\value{
List with class "censoring_score_cox":
  \item{censoring_models}{Fitted \code{coxph} objects by treatment level.}
  \item{censoring_scores}{P(C >= T_i | Z_i, X_i) for observed treatment.}
  \item{censoring_matrix}{(n x J) matrix of P(C >= T_i | Z=j, X_i).}
  \item{n_levels}{Number of treatment levels.}
  \item{treatment_levels}{Sorted treatment values.}
  \item{model_type}{"cox".}
  \item{baseline_hazards}{Baseline cumulative hazards by treatment level.}
  \item{coef_list}{Coefficient vectors by treatment level.}
  \item{vcov_list}{Variance-covariance matrices by treatment level.}
  \item{linear_predictors_matrix}{(n x J) matrix of linear predictors.}
}
\description{
Estimate Censoring Scores Using Cox Regression
}
\details{
Fits Cox models within each treatment group. Censoring scores computed as:
\deqn{K_c^{(j)}(t, X) = \exp(-H_0^{(j)}(t) \cdot \exp(\beta_j' X))}
where \eqn{H_0^{(j)}(t)} is cumulative baseline hazard. Baseline hazards
evaluated at nearest time point for each individual.
}
\keyword{internal}
