% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compnc_robustness.R
\name{compnc_robustness}
\alias{compnc_robustness}
\title{Test Robustness of Phylogenetic Niche Conservatism Analysis Across Multiple Communities}
\usage{
compnc_robustness(
  com,
  trait_data,
  phylo_tree,
  methods = "lambda",
  pca_axes = c("PC1", "PC2"),
  sig_levels = c(0.001, 0.01, 0.05),
  min_abundance = 0,
  n_simulations = 100,
  alpha_level = 0.05,
  tolerance = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{com}{A community matrix with sites as rows and species as columns}

\item{trait_data}{A data frame or matrix containing trait data with species as rows}

\item{phylo_tree}{A phylogenetic tree object of class "phylo"}

\item{methods}{Character string specifying method to use. Options: "lambda" or "K".
Default is "lambda"}

\item{pca_axes}{Character vector specifying which PCA axes to include (e.g., c("PC1", "PC2")).
Default is c("PC1", "PC2")}

\item{sig_levels}{Numeric vector of significance levels for marking results}

\item{min_abundance}{Minimum abundance threshold for including species}

\item{n_simulations}{Integer. Number of simulations to run for robustness testing.
Default is 100}

\item{alpha_level}{Numeric. Significance level for statistical testing.
Default is 0.05}

\item{tolerance}{Numeric. Acceptable difference between target and estimated signal
values during trait simulation. Default is 0.05}

\item{verbose}{Logical indicating whether to show progress and warnings}
}
\value{
A data frame containing the original phylogenetic signal results with
  additional columns:
  \itemize{
    \item robustness: Percentage of simulations that maintain the same statistical
          significance conclusion as the original analysis
    \item signal_sd: Standard deviation of phylogenetic signal values across
          successful simulations
  }
}
\description{
This function evaluates the robustness of phylogenetic signal estimates across
multiple communities by simulating trait data with the same phylogenetic signal
strength as observed, applying the original missing data pattern, and testing
how consistently the statistical significance is recovered across multiple
simulations for each community.
}
\examples{
\donttest{
# Load example data
data("HimalayanBirds")
str(HimalayanBirds)
data("AVONET")
head(AVONET)

# species level
sp <- colnames(HimalayanBirds$com)
sp
subtraits <- extract_traits(sp, AVONET, rank = "species")
head(subtraits)
coverage(subtraits)
pnc(subtraits, HimalayanBirds$phy_species, methods = "lambda", pca_axes = c("PC1", "PC2"))

compnc(com = HimalayanBirds$com, subtraits, HimalayanBirds$phy_species,
       methods = "lambda", pca_axes = NULL)

# Test robustness of phylogenetic signal analysis
# This function's runtime is long
compnc_robustness(HimalayanBirds$com,
                  subtraits,
                  HimalayanBirds$phy_species,
                  methods = "lambda",
                  pca_axes = NULL,
                  n_simulations = 5)
}

}
