% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotInObservation.R
\name{plotInObservation}
\alias{plotInObservation}
\title{Create a ggplot2 plot from the output of summariseInObservation()}
\usage{
plotInObservation(result, facet = NULL, colour = NULL)
}
\arguments{
\item{result}{A summarised_result object (output of
\code{summariseInObservation()}).}

\item{facet}{Columns to face by. Formula format can be provided. See possible
columns to face by with: \code{visOmopResults::tidyColumns()}.}

\item{colour}{Columns to colour by. See possible columns to colour by with:
\code{visOmopResults::tidyColumns()}.}
}
\value{
A plot visualisation.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\examples{
\donttest{
library(dplyr)
library(OmopSketch)
library(omock)

cdm <- mockCdmFromDataset(datasetName = "GiBleed", source = "duckdb")

result <- summariseInObservation(
  observationPeriod = cdm$observation_period,
  output = c("person-days", "record"),
  ageGroup = list("<=40" = c(0, 40), ">40" = c(41, Inf)),
  sex = TRUE
)

result |>
  filter(variable_name == "Person-days") |>
  plotInObservation(facet = "sex", colour = "age_group")

cdmDisconnect(cdm = cdm)
}

}
