% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_omics.R
\name{load_omics}
\alias{load_omics}
\title{Load Proteomics or Metabolomics Data}
\usage{
load_omics(file, type = c("proteomics", "metabolomics"))
}
\arguments{
\item{file}{Path to data file (.csv or .tsv)}

\item{type}{Type of omics data ("proteomics" or "metabolomics")}
}
\value{
A data frame containing the omics dataset
}
\description{
Load Proteomics or Metabolomics Data
}
\examples{
\donttest{
# Create a temporary CSV file with example omics data
tmp <- tempfile(fileext = ".csv")
write.csv(matrix(rnorm(20), nrow = 5), tmp, row.names = FALSE)

# Load the omics data
data <- load_omics(tmp, type = "proteomics")
head(data)
}
}
