% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_decomposition.R
\name{decompose}
\alias{decompose}
\title{Get variance decomposition of orthogonal neural additive model}
\usage{
decompose(object, data = NULL)
}
\arguments{
\item{object}{Either model of class \code{onam} as returned from \link{onam} or
model evaluation outcome as returned from \link{predict.onam}}

\item{data}{Data for which the model is to be evaluated. If \code{NULL}
(DEFAULT), the data from model fitting is used.
with which \code{model} was fitted.}
}
\value{
Returns a named vector of percentage of variance explained by each
interaction order.
}
\description{
Get variance decomposition of orthogonal neural additive model
}
\examples{
\dontshow{if (reticulate::py_module_available(tensorflow)) withAutoprint(\{ # examplesIf}
\donttest{
# Basic example for a simple ONAM-model
# Create training data
n <- 1000
x1 <- runif(n, -2, 2)
x2 <- runif(n, -2, 2)
y <- sin(x1) + ifelse(x2 > 0, pweibull(x2, shape = 3),
  pweibull(-x2, shape = 0.5)) +
  x1 * x2
data_train <- cbind(x1, x2, y)
# Define model
model_formula <- y ~ mod1(x1) + mod1(x2) +
  mod1(x1, x2)
mod1 <- function(inputs) {
  outputs <- inputs \%>\%
    layer_dense(units = 16, activation = "relu") \%>\%
    layer_dense(units = 8, activation = "linear",
                use_bias = TRUE) \%>\%
    layer_dense(units = 1, activation = "linear",
                use_bias = TRUE)
  keras_model(inputs, outputs)
}
list_of_deep_models <- list(mod1 = mod1)
# Fit model
mod <- onam(model_formula, list_of_deep_models,
            data_train, n_ensemble = 1, epochs = 10)
decompose(mod)
}
\dontshow{\}) # examplesIf}
}
