% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_handling.R
\name{discover_mea_structure}
\alias{discover_mea_structure}
\title{Discover MEA Data Structure}
\usage{
discover_mea_structure(
  main_dir,
  experiment_pattern = "MEA\\\\d+",
  file_pattern = "\\\\.csv$",
  verbose = TRUE
)
}
\arguments{
\item{main_dir}{Character. Path to the main directory containing experiment folders}

\item{experiment_pattern}{Character. Regex pattern to identify experiment directories (default: "MEA\\d+")}

\item{file_pattern}{Character. Regex pattern to identify data files (default: "\\.csv$")}

\item{verbose}{Logical. Whether to print progress messages (default: TRUE)}
}
\value{
A list containing:
  - experiments: List of experiment info (directories, files, timepoints, metadata)
  - all_timepoints: Vector of all unique timepoints found across experiments
  - all_variables: Vector of all unique measured variables
  - potential_baselines: Timepoints that might serve as baseline conditions
  - experiment_count: Total number of experiments found
  - discovery_timestamp: When the analysis was performed
}
\description{
This function scans a directory containing MEA (Multi-Electrode Array) experiment 
folders and analyzes the structure of CSV files to identify experiments, timepoints,
measured variables, treatments, and genotypes. It provides a comprehensive overview
of the data organization without loading all files into memory.
}
\details{
The function expects MEA CSV files with standard format:
- Row 121: Well identifiers (A1, A2, B1, etc.)
- Row 122: Treatment conditions
- Row 123: Genotype information  
- Row 124: Exclusion flags
- Rows 125-168: Variable names and measurements

Discover structure of MEA data (requires data directory)
}
