% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filter_empty_rows}
\alias{filter_empty_rows}
\title{Filter empty rows}
\usage{
filter_empty_rows(
  data,
  id_cols = union(get_id_cols_abcd(), get_id_cols_hbcd())
)
}
\arguments{
\item{data}{tibble. The data to be filtered.}

\item{id_cols}{character (vector). The names of the ID columns to be
excluded from the filtering (Default: identifier columns used in ABCD and
HBCD).}
}
\value{
A tibble with the filtered data.
}
\description{
This function filters out rows that are empty
}
\examples{
\dontshow{if (requireNamespace("NBDCtoolsData", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data <- tibble::tibble(
  participant_id = c("sub-001", "sub-002", "sub-003"),
  session_id = c("ses-001", "ses-001", "ses-002"),
  var1 = c(NA, NA, 1),
  var2 = c(NA, NA, 2),
  var3 = c(NA, NA, 3)
)
filter_empty_rows(data)
\dontshow{\}) # examplesIf}
}
