% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinship.emp.R
\name{kinship.emp.fast.between}
\alias{kinship.emp.fast.between}
\title{Approximate empirical kinship}
\usage{
kinship.emp.fast.between(
  population = NULL,
  gen1 = NULL,
  database1 = NULL,
  cohorts1 = NULL,
  gen2 = NULL,
  database2 = NULL,
  cohorts2 = NULL,
  ibd.obs = 50
)
}
\arguments{
\item{population}{Population list}

\item{gen1}{Quick-insert for database1 (vector of all generations to export)}

\item{database1}{First Groups of individuals to consider for the export}

\item{cohorts1}{Quick-insert for database1 (vector of names of cohorts to export)}

\item{gen2}{Quick-insert for database2 (vector of all generations to export)}

\item{database2}{Second Groups of individuals to consider for the export}

\item{cohorts2}{Quick-insert for database2 (vector of names of cohorts to export)}

\item{ibd.obs}{Number of Individual pairs to sample for IBD estimation}
}
\value{
Empirical kinship matrix (IBD-based since Founders) per gen/database/cohort
}
\description{
Function to compute empirical kinship for a set of individuals (not all pairs of individuals are evaluated)
}
\examples{
data(ex_pop)
kinship.emp.fast(population=ex_pop,gen=2)
}
