% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_var_part_pq}
\alias{plot_var_part_pq}
\title{Plot the partition the variation of a phyloseq object}
\usage{
plot_var_part_pq(
  res_varpart,
  cutoff = 0,
  digits = 1,
  digits_quantile = 2,
  fill_bg = c("seagreen3", "mediumpurple", "blue", "orange"),
  show_quantiles = FALSE,
  filter_quantile_zero = TRUE,
  show_dbrda_signif = FALSE,
  show_dbrda_signif_pval = 0.05,
  alpha = 63,
  id.size = 1.2,
  min_prop_pval_signif_dbrda = 0.95
)
}
\arguments{
\item{res_varpart}{(required) the result of the functions \code{\link[=var_par_pq]{var_par_pq()}}
or \code{\link[=var_par_rarperm_pq]{var_par_rarperm_pq()}}}

\item{cutoff}{The values below cutoff will not be displayed.}

\item{digits}{The number of significant digits.}

\item{digits_quantile}{The number of significant digits for quantile.}

\item{fill_bg}{Fill colours of ellipses.}

\item{show_quantiles}{Do quantiles are printed ?}

\item{filter_quantile_zero}{Do we filter out value with quantile encompassing
the zero value?}

\item{show_dbrda_signif}{Do dbrda significance for each component is printed
using *?}

\item{show_dbrda_signif_pval}{(float, \verb{[0:1]}) The value under which the
dbrda is considered significant.}

\item{alpha}{(int, \verb{[0:255]}) Transparency of the fill colour.}

\item{id.size}{A numerical value giving the character expansion factor for the names of circles or ellipses.}

\item{min_prop_pval_signif_dbrda}{(float, \verb{[0:1]}) Only used if using the
result of \code{\link[=var_par_rarperm_pq]{var_par_rarperm_pq()}} function. The * for dbrda_signif is only add if
at least \code{min_prop_pval_signif_dbrda} of permutations show significance.}
}
\value{
A plot
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


Graphical representation of the partition of variation obtain with \code{\link[=var_par_pq]{var_par_pq()}}.
}
\details{
This function is mainly a wrapper of the work of others.
Please make a reference to \code{vegan::varpart()} if you
use this function.
}
\examples{
\donttest{
if (requireNamespace("vegan")) {
  data_fungi_woNA <- subset_samples(data_fungi, !is.na(Time) & !is.na(Height))
  res_var_9 <- var_par_rarperm_pq(
    data_fungi_woNA,
    list_component = list(
      "Time" = c("Time"),
      "Size" = c("Height", "Diameter")
    ),
    nperm = 9,
    dbrda_computation = TRUE
  )
  res_var_2 <- var_par_rarperm_pq(
    data_fungi_woNA,
    list_component = list(
      "Time" = c("Time"),
      "Size" = c("Height", "Diameter")
    ),
    nperm = 2,
    dbrda_computation = TRUE
  )
  res_var0 <- var_par_pq(data_fungi_woNA,
    list_component = list(
      "Time" = c("Time"),
      "Size" = c("Height", "Diameter")
    ),
    dbrda_computation = TRUE
  )
  plot_var_part_pq(res_var0, digits_quantile = 2, show_dbrda_signif = TRUE)
  plot_var_part_pq(res_var_9,
    digits_quantile = 2, show_quantiles = TRUE,
    show_dbrda_signif = TRUE
  )
  plot_var_part_pq(
    res_var_2,
    digits = 5,
    digits_quantile = 2,
    cutoff = 0,
    show_quantiles = TRUE
  )
}
}
}
\seealso{
\code{\link[=var_par_rarperm_pq]{var_par_rarperm_pq()}}, \code{\link[=var_par_pq]{var_par_pq()}}
}
\author{
Adrien Taudière
}
