% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dada_phyloseq.R
\name{add_info_to_sam_data}
\alias{add_info_to_sam_data}
\title{Add information to sample_data slot of a phyloseq-class object}
\usage{
add_info_to_sam_data(
  physeq,
  df_info = NULL,
  add_nb_seq = TRUE,
  add_nb_otu = TRUE
)
}
\arguments{
\item{physeq}{(required) a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{df_info}{: A dataframe with rownames matching for sample names of the
phyloseq object}

\item{add_nb_seq}{(Logical, default TRUE) Does we add a column nb_seq
collecting the number of sequences per sample?}

\item{add_nb_otu}{(Logical, default TRUE) Does we add a column nb_otu
collecting the number of OTUs per sample?}
}
\value{
A phyloseq object with an updated sam_data slot
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


Warning: The value nb_seq and nb_otu may be outdated if you transform your
phyloseq object, e.g. using the \code{\link[=subset_taxa_pq]{subset_taxa_pq()}} function
}
\examples{

data_fungi <- add_info_to_sam_data(data_fungi)
boxplot(data_fungi@sam_data$nb_otu ~ data_fungi@sam_data$Time)

new_df <- data.frame(
  variable_1 = runif(n = nsamples(data_fungi), min = 1, max = 20),
  variable_2 = runif(n = nsamples(data_fungi), min = 1, max = 2)
)
rownames(new_df) <- sample_names(data_fungi)
data_fungi <- add_info_to_sam_data(data_fungi, new_df)
plot(data_fungi@sam_data$nb_otu ~ data_fungi@sam_data$variable_1)
}
\author{
Adrien Taudière
}
