% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMeasurementValueAsNumeric.R
\name{plotMeasurementValueAsNumber}
\alias{plotMeasurementValueAsNumber}
\title{Plot summariseMeasurementTiming results.}
\usage{
plotMeasurementValueAsNumber(
  result,
  x = "unit_concept_name",
  plotType = "boxplot",
  facet = c("codelist_name", "concept_name"),
  colour = c("cdm_name", "unit_concept_name", visOmopResults::strataColumns(result)),
  style = NULL
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{x}{Columns to use as horizontal axes. See options with
`visOmopResults::plotColumns(result)`.}

\item{plotType}{Type of plot, either "boxplot", "barplot", or "densityplot".}

\item{facet}{Columns to facet by. See options with
`visOmopResults::plotColumns(result)`. Formula input is also allowed to
specify rows and columns.}

\item{colour}{Columns to color by. See options with
`visOmopResults::plotColumns(result)`.}

\item{style}{Pre-defined style to apply: "default" or
"darwin" - the latter just for gt and flextable. If NULL the "default" style
is used.}
}
\value{
A ggplot.
}
\description{
Plot summariseMeasurementTiming results.
}
\examples{
\donttest{
library(MeasurementDiagnostics)

cdm <- mockMeasurementDiagnostics()

result <- summariseMeasurementUse(
  cdm = cdm,
  bySex = TRUE,
  codes = list("test_codelist" = c(3001467L, 45875977L))
)

plotMeasurementValueAsNumber(result)

CDMConnector::cdmDisconnect(cdm)
}
}
