% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-generics.R,
%   R/RLum.Analysis-class.R, R/RLum.Data.Curve-class.R, R/RLum.Results-class.R
\name{length_RLum}
\alias{length_RLum}
\alias{length_RLum,RLum.Analysis-method}
\alias{length_RLum,RLum.Data.Curve-method}
\alias{length_RLum,RLum.Results-method}
\title{Length retrieval function for RLum-class objects}
\usage{
length_RLum(object)

\S4method{length_RLum}{RLum.Analysis}(object)

\S4method{length_RLum}{RLum.Data.Curve}(object)

\S4method{length_RLum}{RLum.Results}(object)
}
\arguments{
\item{object}{\linkS4class{RLum} (\strong{required}):
S4 object of class \code{RLum}}
}
\value{
An \link{integer} indicating the length of the object.
}
\description{
The function provides a generalised access point for specific
\linkS4class{RLum} objects. Depending on the input object, the corresponding
function will be selected.
}
\section{Functions}{
\itemize{
\item \code{length_RLum(RLum.Analysis)}: Returns the number of records stored in the object.

\item \code{length_RLum(RLum.Data.Curve)}: Returns the number of channels in the curve, which is the maximum of the
value time/temperature of the curve (corresponding to the stimulation
length).

\item \code{length_RLum(RLum.Results)}: Returns the number of stored data elements.

}}
\section{Function version}{
 0.1.0
}

\seealso{
\linkS4class{RLum.Data.Curve},
\linkS4class{RLum.Data.Image},
\linkS4class{RLum.Data.Spectrum},
\linkS4class{RLum.Analysis},
\linkS4class{RLum.Results}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2025. length_RLum(): Length retrieval function for RLum-class objects. Function version 0.1.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.2. https://r-lum.github.io/Luminescence/
}

\keyword{utilities}
