% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plantcoupmodel.R
\name{plant_coupmodel}
\alias{plant_coupmodel}
\title{Interpolate plant properties using the 'Coupmodel' method.}
\usage{
plant_coupmodel(
  minval_before_incr,
  minval_after_decr = minval_before_incr,
  maxval,
  doy.incr,
  doy.max,
  doy.min,
  shape.incr,
  shape.decr,
  maxdoy
)
}
\arguments{
\item{minval_before_incr}{Minimum value used for the time period before
\code{doy.incr}.}

\item{minval_after_decr}{Minimum value used for time period after
\code{doy.decr}.}

\item{maxval}{Maximum value.}

\item{doy.incr}{Day of year when increasing from \code{minval_before_incr} to
\code{maxval} begins.}

\item{doy.max}{Day of year when \code{maxval} is reached.}

\item{doy.min}{Day of year when \code{minval_after_decr} is reached.}

\item{shape.incr}{Shape parameter of the increasing phase.}

\item{shape.decr}{Shape parameter of the decreasing phase.}

\item{maxdoy}{Length of the year, 366 for leap years, 365 for normal years.}
}
\value{
A numeric vector of length \code{maxdoy}.
}
\description{
Creates a daily sequence for one year from parameters
}
\examples{
plot(plant_coupmodel(0,0.2,5,121, 200, 280, 0.3, 3, 365))

}
\references{
Jansson, P.-E. & Karlberg, L. (2004): "Coupled heat and mass transfer model for
soil-plant-atmosphere systems."
\emph{Royal Institute of Technolgy, Dept of Civil and Environmental Engineering Stockholm}
}
