LSMsim=function(N,nit,ndim_z,nc=NULL,theta=NULL,b=NULL,z=NULL,w=NULL,gamma=NULL){

  if(is.null(nc)) nc=rep(2,nit)
  if(!is.null(b)){
    if(ncol(b)!=nit) stop("b should be a matrix of max(nc-1) by nit")
    if(nrow(b)!=max(nc-1)) stop("b should be a matrix of max(nc-1) by nit")
    b=rbind(Inf,b,NA)
    for(i in 1:nit) b[is.na(b[,i]),i][1]=-Inf
  }
  if(is.null(theta)) theta=stats::rnorm(N)
  if(is.null(z)) z=matrix(stats::rnorm(ndim_z*N),N,ndim_z)
  if(is.null(w)){
    w=matrix(stats::rnorm(ndim_z*nit),nit,ndim_z)

    w[,1]=seq(2,-2,length=nit)
  if(ndim_z>1) for(s in 2:ndim_z) w[,s]=stats::runif(nit,-2,2)
}
  if(is.null(gamma)) gamma=2

  X=dist=matrix(0,N,nit)
  for(p in 1:N)
    for(i in 1:nit)
      for(s in 1:ndim_z) dist[p,i]=dist[p,i]+(z[p,s]-w[i,s])^2

  if(is.null(b)){
    b=matrix(,max(nc-1)+2,nit)
    me=seq(-2,2,length=nit)
    for(i in 1:nit)
      b[1:(nc[i]+1),i]=-sort(c(-Inf,stats::rnorm(nc[i]-1,me[i],1),Inf))
    b=t(t(b)+gamma*apply(sqrt(dist),2,mean))
  }

  for(p in 1:N)
    for(i in 1:nit){{
      prob=c()
      for(c in 1:nc[i]) prob[c]=stats::plogis(theta[p]+b[c,i]-gamma*sqrt(dist[p,i]))-stats::plogis(theta[p]+b[c+1,i]-gamma*sqrt(dist[p,i]))
      X[p,i]=sample(0:(nc[i]-1),1,prob=prob)
    }}
  if(sum(nc-1)==nit) b_out=b[2,]
  else{
    b=b[-1,]
    for(i in 1:nit) b[is.infinite(b[,i]),i]=NA
    b=b[-(max(nc-1)+1),]
    b_out=b
  }

  if(ndim_z>1) rot=LSMrotate(z,w) else rot=list(zt=NULL,wt=NULL)
  return(list(X=X,par=list(theta=theta,b=b_out,z=z,w=w,gamma=gamma,zt=rot$zt,wt=rot$wt)))
}
