% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arriaga.R
\name{sen_arriaga_instantaneous2}
\alias{sen_arriaga_instantaneous2}
\title{Estimate sensitivity of life expectancy for a set of mortality rates by perturbing in the log space.}
\usage{
sen_arriaga_instantaneous2(
  mx,
  age = 0:(length(mx1) - 1),
  sex = "t",
  nx = rep(1, length(mx)),
  perturb = 1e-06,
  closeout = TRUE
)
}
\arguments{
\item{mx}{numeric vector of mortality rates (central death rates)}

\item{age}{integer vector of the lower bound of each age group (currently only single ages supported)}

\item{sex}{character Male (\code{"m"}), Female (\code{"f"}), or Total (\code{"t"})}

\item{nx}{integer vector of age intervals, default 1.}

\item{perturb}{numeric constant, a very small number}

\item{closeout}{logical. Default \code{TRUE}. Shall we use the HMD Method Protocol to close out the \code{ax} and \code{qx} values? See details.}
}
\value{
numeric vector of sensitivity of life expectancy to perturbations in \code{mx}
}
\description{
This is a second approach for estimating the sensitivity for a single set of rates. Here, rather than directly expanding and contracting rates to convert \code{mx} into \code{mx1} and \code{mx2} we instead shift the logged mortality rates up and down by the factor \code{perturb = h}. Specifically:
\deqn{m_{x}^{1} = e^{\ln\left(m_x\right) + h}}
\deqn{m_{x}^{2} = e^{\ln\left(m_x\right) - h}}
}
\examples{
a   <- .001
b   <- .07
x   <- 0:100
mx <- a * exp(x * b)
# the multiplicative perturbation:
s1 <- sen_arriaga_instantaneous(mx)
s2 <- sen_arriaga_instantaneous2(mx)
plot(x,
     s1 - s2,
     pch = 16,
     cex=.5,
     main = "very similar")

}
\seealso{
\code{\link{sen_arriaga_instantaneous}}
}
