% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powered_r.R
\name{powered_r}
\alias{powered_r}
\title{Compute r's post-hoc power}
\usage{
powered_r(r = 0.2, n = 200L, sig_level = 0.05)
}
\arguments{
\item{r}{Pearson's correlation. Cohen(1988) suggested >=0.1, >=0.3, and >=0.5 as cut-off values
of Pearson's correlation r for small, medium, and large effect sizes, respectively.}

\item{n}{The current sample size. Non-integer \code{n} would be converted to be an integer using \code{as.integer()}.
\code{n} should be at least 3.}

\item{sig_level}{Expected significance level.}
}
\value{
Integer \code{n}, the t_test of \code{r} at the sample size \code{n} with \code{df}, \code{SE} of \code{r},
\code{p} (the p-value of t-test), and the post-hoc power analysis with \code{delta}
(the non-centrality parameter of the t-distribution for the alternative hypothesis),
and \code{power} (the post-hoc power of \code{r} at the sample size \code{n}).
}
\description{
Compute r's post-hoc power
}
\examples{
powered_r()
}
\references{
Aberson, C. L. (2019). \emph{Applied power analysis for the behavioral sciences}. Routledge.

Cohen, J. (1988). \emph{Statistical power analysis for the behavioral sciences} (2nd ed.). Routledge.
}
