% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{residuals.HZIP}
\alias{residuals.HZIP}
\title{Compute Residuals for HZIP Models}
\usage{
\method{residuals}{HZIP}(object, ...)
}
\arguments{
\item{object}{An object of class \code{HZIP}, typically returned from \code{\link{hzip}}.}

\item{...}{Additional arguments (not used).}
}
\value{
A numeric vector of residuals with length equal to the total number
  of observations in the dataset.
}
\description{
This function calculates residuals for objects of class \code{HZIP}
usingrandomized quantile residuals. The computation is performed efficiently
using C++ functions for predicting random effects and calculating
residuals.
}
\details{
The function internally groups the data by individual (\code{Ind}), constructs
model matrices for both zero-inflation and count parts of the model, and then
calls the C++ functions \code{predict_HZIP_cpp_vec} and \code{r_ij_cpp_vec}
to efficiently compute the residuals. Random effects are integrated using
adaptive quadrature based on the supplied \code{nodes} and \code{weights}.
}
\examples{
\donttest{
fit.salamander <- hzip(y ~ mined|mined+spp,data = salamanders)
residuals(fit.salamander)
}

}
