% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WtCoxG.R
\name{fitNullModel.WtCoxG}
\alias{fitNullModel.WtCoxG}
\title{Fit weighted Cox null model with outlier handling and batch-effect QC}
\usage{
fitNullModel.WtCoxG(
  response,
  designMat,
  subjData,
  control,
  data,
  GenoFile,
  GenoFileIndex,
  SparseGRMFile,
  SurvTimeColumn,
  IndicatorColumn,
  ...
)
}
\arguments{
\item{response}{\code{survival::Surv} response (time-to-event). Residuals are
not supported here.}

\item{designMat}{Numeric matrix (n x p) of covariates.}

\item{subjData}{Character vector of subject IDs aligned with rows of \code{designMat}.}

\item{control}{List with fields such as \code{OutlierRatio}.}

\item{data}{Data frame used for optional batch-effect QC.}

\item{GenoFile}{Character. PLINK prefix (without extension) used when
sampling markers for QC.}

\item{GenoFileIndex}{Character. Path to an index file used in QC workflow.}

\item{SparseGRMFile}{Character. Path to sparse GRM used in QC workflow.}

\item{SurvTimeColumn}{Character. Column name in \code{data} containing survival time.}

\item{IndicatorColumn}{Character. Column name in \code{data} containing event indicator (0/1).}

\item{...}{Optional named parameters forwarded to QC (e.g., \code{RefAfFile}).}
}
\value{
A list of class \code{"WtCoxG_NULL_Model"} with elements:
\describe{
\item{mresid}{Martingale residuals from weighted Cox model.}
\item{Cova}{Design matrix used in the null model (n x p).}
\item{yVec}{Event indicator extracted from \code{Surv}.}
\item{weight}{Observation weights derived from reference prevalence.}
\item{RefPrevalence}{Reference prevalence used to define weights.}
\item{N}{Number of subjects.}
\item{outLierList}{Lists indices (0-based) and residual subsets for SPA.}
\item{control}{Copy of control options used.}
\item{mergeGenoInfo}{QC-derived marker metadata for batch-effect testing (if run).}
\item{subjData}{Character vector of subject IDs.}
}
}
\description{
Fits a weighted Cox model using case/control weighting based on reference
prevalence and identifies residual outliers for SPA testing. Optionally
performs batch-effect QC by cross-referencing external allele frequencies.
}
\keyword{internal}
