% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_simulate_cvd.R
\name{gg_simulate_cvd}
\alias{gg_simulate_cvd}
\title{Simulate Colorblind Vision}
\usage{
gg_simulate_cvd(plot, type = "deutan")
}
\arguments{
\item{plot}{A ggplot2 object}

\item{type}{Type of CVD: "deutan" (green-blind), "protan" (red-blind), or "tritan" (blue-blind)}
}
\value{
A modified ggplot2 object showing the simulated view
}
\description{
Shows how your plot appears to people with different types of color vision deficiency
}
\examples{
library(ggplot2)
p <- ggplot(mtcars, aes(wt, mpg, color = factor(cyl))) +
  geom_point() +
  scale_color_manual(values = c("red", "green", "blue"))
gg_simulate_cvd(p, type = "deutan")
}
