% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{check_data}
\alias{check_data}
\title{Check validity of the data and headers}
\usage{
check_data(
  data,
  depvar_header = NULL,
  i_header = NULL,
  j_header = NULL,
  t_header = NULL
)
}
\arguments{
\item{data}{Either a data.frame or a list of data matrices of length \eqn{R}. See \strong{Details}.}

\item{depvar_header}{A character string specifying the header of the dependent variable. See \strong{Details}.}

\item{i_header}{A character string specifying the header of the block identifier. See \strong{Details}.}

\item{j_header}{A character string specifying the header of the individual identifier. See \strong{Details}.}

\item{t_header}{A character string specifying the header of the time identifier. See \strong{Details}.}
}
\value{
A list of data matrices of length \eqn{R}.
}
\description{
This is an internal function which checks the validity of the data and
provide a list of matrices of length \eqn{R} for estimation.
}
\details{
See \strong{Details} of [GCC()].
}
\examples{
panel <- UKhouse # load the data
Y_list <- check_data(panel,
  depvar_header = "dlPrice", i_header = "Region",
  j_header = "LPA_Type", t_header = "Date"
)
}
