% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_stand_spatial.R
\name{fe_stand_spatial}
\alias{fe_stand_spatial}
\title{User Friendly Construction of an \strong{fe_stand_spatial} Object from a List of
Data Frames}
\usage{
fe_stand_spatial(
  x,
  tree_frame_name = "trees",
  tree_pos_frame_name = "tree_positions",
  outline_frame_name = "outline",
  orientation = NA,
  tree_id_col,
  species_id_col,
  time_yr_col,
  dbh_cm_col,
  x_m_col,
  y_m_col,
  stand_id = "my_fe_stand_spatial",
  layer_key_col = NA,
  age_yr_col = NA,
  height_m_col = NA,
  crown_base_height_m_col = NA,
  crown_radius_m_col = NA,
  removal_col = NA,
  ingrowth_col = NA,
  n_rep_ha_col = NA,
  small_trees = data.frame(),
  verbose = TRUE
)
}
\arguments{
\item{x}{named list of two or three data frames to be coerced into the goal
object. One data frame must contain the single tree data; it has the same
requirements as for the input data frame \code{x} of the function
\code{\link{fe_stand}}. Another data frame must contain the tree positions.
The third data frame is optional, if provided it must contain a coordinate
description of the stand/plot outline. See the Details section for all
requirements.}

\item{tree_frame_name}{name of the data frame in \code{x} that contains the
single tree data (default: "trees")}

\item{tree_pos_frame_name}{name of the data frame in \code{x} that contains
the tree positions (default: "tree_positions")}

\item{outline_frame_name}{name of the data frame in \code{x} that contains
the stand outline information (default: "outline"). It is possible to have
no defined stand outline; in this case outline_frame_name must be
\code{NULL}, and n_rep_ha_col must be given (with no missing values).}

\item{orientation}{counterclockwise angle in degrees between the y-axis of
the coordinate system of the stand outline and the tree positions and the
north direction. The value \code{NA} is allowed.}

\item{tree_id_col}{name of the column in the trees and tree_positions data
frames  which contains the tree id's (\code{character}, required, must not
contain missing values)}

\item{species_id_col}{name of the column in trees data frame which contains
the species id's. Must be an object of one  of the \code{fe_species}
classes supported by this package. This column is required, must not
contain missing values.}

\item{time_yr_col}{name of the column in the trees data frame which provides
time information in years (\code{character}, required, must not contain
missing values)}

\item{dbh_cm_col}{name of the column in the trees data frame which contains
the dbh in cm (\code{character}, required, must not contain missing values)}

\item{x_m_col}{name of the column in the tree positions data frame that
contains the x-coordinates of the tree stem centers in m. The coordinates
must adhere to the same coordinate system as the coordinates in the plot
outline data frame. If the latter is provided, its x column must also have
the name provided with \code{x_m_col}.}

\item{y_m_col}{name of the column in the tree positions data frame that
contains the y-coordinates of the tree stem centers in m. The coordinates
must adhere to the same coordinate system as the coordinates in the plot
outline data frame. If the latter is provided, its x column must also have
the name provided with \code{y_m_col}.}

\item{stand_id}{arbitrary id of the stand (\code{character}, default:
"my_fe_stand_spatial")}

\item{layer_key_col}{name of the column in \code{x} that contains codes for
the stand layer a given tree belongs to. These codes are whole numbers.
The following values are allowed: 1 - Main stand, 2 - Understorey,
3 - Pregeneration (ger: "Vorausverjuengung"), 4 - Remnant trees, hold over
trees, veteran trees (ger: "Nachhiebsreste", "Ueberhaelter", "Altbaeume").
Must not contain missing values if provided. If not provided, it will be
set to 1 (main stand) for every tree.}

\item{age_yr_col}{name of the column in the trees data frame which provides
the tree ages in years (\code{character}, optional, may contain missing
values)}

\item{height_m_col}{name of the column in the trees data frame which provides
the tree heights in m (\code{character}, optional, may contain missing
values)}

\item{crown_base_height_m_col}{name of the column in the trees data frame
which provides the crown base heights in m (\code{character}, optional, may
contain missing values)}

\item{crown_radius_m_col}{name of the column in the trees data frame which
provides the crown radii in m (\code{character}, optional, may contain
missing values)}

\item{removal_col}{name of the column in the trees data frame which provides
the tree's removal status. If \code{TRUE}, this indicates the tree was
removed or dead at the time indicated in \code{age_yr_col}
(\code{character}, optional, must not contain missing values if provided).
If not provided, the removal status will be \code{FALSE} for all trees in
the resulting \code{fe_stand} object.}

\item{ingrowth_col}{name of the column in the trees data frame which provides
the tree's ingrowth status. If \code{TRUE}, this indicates a tree that grew
newly in at the time indicated in \code{age_yr_col} (\code{character},
optional, must not contain missing values if provided). If not provided,
the ingrowth status will be \code{FALSE} for all trees in the resulting
\code{fe_stand} object.}

\item{n_rep_ha_col}{name of the column in the trees data frame which provides
each tree's representation number per ha. Not required if a stand outline
is provided in \code{x}. If a stand outline is given, n_rep_ha will be
always recalculated based on the outline and the tree positions.}

\item{small_trees}{An \code{fe_stand_spatial} object does contain an extra
slot for small trees, defined as trees which are too small to have an own
dbh (i.e. having a height > 1.3 m). So far, this slot is still
experimental. The only requirement is that it is a \code{data.frame}. Such
a \code{data.frame} can be provided via this parameter, it will be directly
put into the goal object's \code{small_trees} slot. The default is a
\code{data.frame} with zero rows and zero columns (\code{data.frame()}).}

\item{verbose}{name of the column in the trees data frame which provides the
tree's ingrowth status. If \code{TRUE}, this indicates a tree that grew
newly in at the time indicated in \code{age_yr_col} (\code{character},
optional, must not contain missing values if provided). If not provided,
the ingrowth status will be \code{FALSE} for all trees in the resulting
\code{fe_stand} object.}
}
\value{
If the user input allows to construct a well-defined
\code{fe_stand_spatial} object, this object will be returned. If not, the
function will terminate with an error.
}
\description{
\code{fe_stand_spatial()} provides a user-friendly interface for the
constructor \code{\link{new_fe_stand_spatial}}. While the constructor does
not prevent users from creating malformed \code{fe_stand_spatial} objects,
\code{fe_stand_spatial} does everything to achieve a well-defined object
mostly based on an initial list of data.frames that might be, e.g. drawn out
of a user's own data base.
}
\details{
An object of class \code{fe_stand_spatial} is a child object of
\code{fe_stand} which, however, contains information about the horizontal
positions of the trees and the horizontal outline of the stand. All spatial
information and its processing is based on the R-package
\href{https://CRAN.R-project.org/package=sf}{sf}.

The input object \code{x} to \code{fe_stand_spatial} must be a list that
comprises two and an optional third data frame(s):
\itemize{ \item a data frame containing the single tree information (same
requirements as for \code{\link{fe_stand}}). This data frame must contain a a
minimum set of columns (tree id, species id, time variable, diameter at
breast height). These columns must not contain missing values. Other columns
(containing tree height, height to crown base, crown radius, tree age) are
optional for the user to provide. If provided, they may contain missing
values. If not provided, these columns will only contain missing values in
the \code{fe_stand_spatial} object. The columns about the trees' removal and
ingrowth status are also optional, but if provided, they must \emph{not} contain
missing values. If not provided, both columns will be filled with
\code{FALSE} in the resulting \code{fe_stand_spatial} object.
\code{fe_stand_spatial} will automatically add a column \code{n_rep_ha} which
contains for each tree the number of trees it represents per ha. This may
seem redundant if looking at \code{fe_stand} objects alone, but it allows a
broad range of evaluation functions to be applied to different objects
containing trees. Note that in a \code{fe_stand_spatial} object trees are
allowed which are outside the actual stand outine (e.g. "buffer zone trees").
Such trees will be automatically identified by their coordinates and not
taken into account for calculating the stand's growth and yield
characteristics. However, they can be included in visual displays.

\item a data frame that contains information about the tree positions. This
is not part of the first data frame, because the latter could contain several
observations (at different times) of the same tree, which would lead to
redundant coordinate representation. This data frame must contain a column
with tree id's, and the x and y coordinates of the stem center points
according to the same coordinate system as the stand outline (see below).
\code{NA} values are not allowed in this data frame.

\item The optional third data frame must comprise the corner points of a
polygon that describes the stand's outline. The polygon must not be
self-intersection, therefore, the points must be given in correct sequence.
The first point does not need to be repeated - \code{fe_stand_spatial} will
take care for closing the polygon. This data frame needs to contain only the
x and y coordinates of the  corner points (in m), no \code{NA} values
allowed.}
}
\examples{
# Transform the example data collection mm_forest_1_raw (could e.g. have
# been drawn out of a user's data base) into an fe_stand_spatial object

mm_forest_spatial <- mm_forest_1_raw |>
  fe_stand_spatial(
    orientation = mm_forest_1_raw$north_dev,
    tree_id_col = "tree_id",
    species_id_col = "species_id",
    time_yr_col = "time_yr",
    dbh_cm_col = "dbh_cm",
    x_m_col = "x",
    y_m_col = "y",
    stand_id = mm_forest_1_raw$stand_id,
    height_m_col = "height_m",
    crown_base_height_m_col = "crown_base_height_m",
    crown_radius_m_col = "crown_radius_m",
    removal_col = "removal"
  )

# Show a little summary, display scientific species names
options(fe_spec_lang = "sci")
mm_forest_spatial |> summary()

}
