% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{random_Phi}
\alias{random_Phi}
\title{Randomly generate an autoregressive coefficient matrix \eqn{\Phi}}
\usage{
random_Phi(p, num_nonzero)
}
\arguments{
\item{p}{Integer. Dimension of the square matrix (\eqn{p} variables).}

\item{num_nonzero}{Integer. Target number of nonzero off-diagonal
entries in \eqn{\Phi}.}
}
\value{
A numeric \eqn{p \times p} matrix representing the autoregressive
coefficient matrix \eqn{\Phi} with random diagonal entries in
\{0.5, -0.5\} and approximately `num_nonzero` nonzero off-diagonal
elements.
}
\description{
Generates a \eqn{p \times p} autoregressive coefficient matrix
\eqn{\Phi} for the VAR(1) component in the proposed model. The diagonal
entries are randomly chosen from \{0.5, -0.5\}, and a specified number of
off-diagonal elements are randomly assigned nonzero values to introduce
cross-dependence among variables.
}
\details{
The diagonal elements are sampled independently from the set
\eqn{\{0.5, -0.5\}}. Nonzero off-diagonal entries are then placed at random
positions until the total number of nonzero off-diagonal elements reaches
at least \code{num_nonzero}. Each nonzero off-diagonal element has magnitude
0.1 or 0.2 with equal probability and a randomly assigned sign. The resulting
matrix \eqn{\Phi} governs the temporal dependence of the stationary VAR(1)
process
\deqn{\boldsymbol{\epsilon}_t = \Phi \boldsymbol{\epsilon}_{t-1} +
\boldsymbol{\nu}_t.}
}
