% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{tab_sample}
\alias{tab_sample}
\title{Generate tabulated samples from probability vectors}
\usage{
tab_sample(n, mu, prob = FALSE)
}
\arguments{
\item{n}{vector or nested list of sample sizes.}

\item{mu}{matrix (row-wise) or nested list containing probability vectors to sample from. The structure of \code{n} and \code{mu} must be the same.}

\item{prob}{logical value indicating whether probabilities (instead of counts) should be returned.}
}
\value{
The count vectors corresponding to the generated samples. Has the same structure as \code{mu}.
}
\description{
Generate count vectors instead of samples, i.e., vectors giving the number of times a sample was observed at the respective points.
}
\examples{
## matrix example

mu <- matrix(c(0.01, 0.99, 0.5, 0.5), 2, 2, TRUE)
n <- c(80, 20)

set.seed(123)
cv <- tab_sample(n, mu)
print(cv)
# sample sizes are rowsums
print(rowSums(cv))
# empirical probability vectors
print(sweep(cv, 1, n, "/"))
set.seed(123)
# same result
print(tab_sample(n, mu, prob = TRUE))

## list example

mu <- list(
   list(c(0.3, 0.7), c(0.25, 0.75)),
   list(c(0, 1), c(0.5, 0.5))
)
n <- list(list(100, 120), list(80, 90))

set.seed(123)
cv <- tab_sample(n, mu)
print(cv)
# empirical probability vectors
print(rapply(cv, \(x) x / sum(x), how = "replace"))
set.seed(123)
print(tab_sample(n, mu, prob = TRUE))
}
