% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{residuals.gmjmcmc_merged}
\alias{residuals.gmjmcmc_merged}
\title{Residuals for GMJMCMC Merged Model}
\usage{
\method{residuals}{gmjmcmc_merged}(object, y, x, ...)
}
\arguments{
\item{object}{Object of class "gmjmcmc_merged".}

\item{y}{Respnse.}

\item{x}{Covariates.}

\item{...}{Additional arguments (ignored).}
}
\value{
Vector of residuals.
}
\description{
Computes residuals as the difference between observed and predicted values.
}
\examples{
data(exoplanet)
model <- fbms(semimajoraxis ~ ., data = exoplanet, 
method = "gmjmcmc.parallel", transforms = c("sigmoid"), 
runs = 2, cores = 1)
hist(residuals(model, exoplanet[,1], exoplanet[,-1]))
}
