% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{epi_prevalence}
\alias{epi_prevalence}
\title{Disease Prevalence Data by Region and Age Group}
\format{
A data frame with 12 rows and 7 columns:
\describe{
  \item{region}{Character, region name (e.g., North, South, East, West).}
  \item{age_group}{Character, age group (e.g., 0-19, 20-59, 60+).}
  \item{cases}{Numeric, number of disease cases.}
  \item{population}{Numeric, population size in the region and age group.}
  \item{prevalence}{Numeric, prevalence percentage (cases / population * 100).}
  \item{lat}{Numeric, latitude for spatial mapping.}
  \item{lon}{Numeric, longitude for spatial mapping.}
}
}
\source{
Simulated data for demonstration purposes.
}
\usage{
epi_prevalence
}
\description{
A dataset containing disease prevalence data across different regions and age groups, including spatial coordinates.
}
\examples{
data("epi_prevalence")
library(sp)
coordinates(epi_prevalence) <- ~lon+lat
epi_visualize(epi_prevalence, x = "prevalence", type = "map")
epi_analyze(epi_prevalence,outcome    = "cases",population = "population",type       = "summary")
if (interactive()) {
epi_prevalence$region_id <- as.numeric(factor(epi_prevalence$region))
epi_visualize(epi_prevalence, x = "region_id", y = "prevalence", type = "scatter")
with(epi_prevalence, axis(1, at = unique(region_id), labels = levels(factor(region))))
}
}
\keyword{datasets}
