% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/par.uncertainty.function.R
\name{par.uncertainty}
\alias{par.uncertainty}
\title{Semi-variogram model parameter uncertainty}
\usage{
par.uncertainty(
  vario.mod.output,
  mod.nr,
  par.est = NULL,
  data = NULL,
  max.dist = NULL,
  nbins = NULL,
  B = 1000,
  threshold.factor = 3,
  fit.method = 7,
  mc.cores = 1
)
}
\arguments{
\item{vario.mod.output}{An output of the \code{vario.mod} function containing the
information of the estimated exponential semi-variogram model of interest.}

\item{mod.nr}{The index number specifiying one of the exponential semi-variogram models
listed in the \code{vario.mod.ouput}.}

\item{par.est}{A vector of length three containing the estimated parameters:
the nugget effect, the partial sill and the shape parameter
of the estimated exponential semi-variogram model.
It is automatically extracted from the \code{vario.mod.output}, if provided.}

\item{data}{The data frame or matrix used to estimate the exponential semi-variogram of interest
containing the x-coordinates in meters in the first column,
the y-coordinates in meters in the second column and the data values in the third column.
It is automatically extracted from the vario.mod.output, if provided.}

\item{max.dist}{The maximal distance used for the estimation of the
 exponential semi-variogram model of interest.
It is automatically extracted from the vario.mod.output, if provided.}

\item{nbins}{The number of bins used for the estimation of the exponential
semi-variogram model of interest.
It is automatically extracted from the vario.mod.output, if provided.}

\item{B}{The number of bootstrap repetitions to generate a set of re-estimates
of each parameter.}

\item{threshold.factor}{The threshold factor specifies the filter within the filtered
bootstrap method (see details). If not specified, a default value of 3 is used.}

\item{fit.method}{The fit method used in the semivariogram estimation with the gstat package.}

\item{mc.cores}{The number of cores used for bootstrapping, utilizing the parallel R-package. More than one core is not supported on windows systems.}
}
\value{
The function returns parameter estimates and corresponding standard error estimates
together and provides a list with the following objects:
\item{se}{A vector of length 3 containing the estimated standard errors of the
          nugget effect, the partial sill and the shape parameter.}
\item{unc.table}{A matrix containing the parameter estimates and the corresponding standard errors.}
\item{re_estimates}{A matrix with B rows containing the set of bootstrap re-estimates for each parameter.}
\item{re_estimate.mean}{A vector containing the mean parameter estimates based on the set of bootstrap re-estimates for each parameter.}
\item{call}{The function call.}
}
\description{
Standard error estimates for the nugget effect \eqn{c_0},  partial sill \eqn{\sigma_0^2} and
shape parameter \eqn{\phi} of a fitted exponential semi-variogram model.
}
\details{
\strong{Two alternative approaches for the input of the arguments:}

         1. Provide the arguments
         vario.mod.output (output object from vario.mod function) and
         mod.nr (number of the model in the infotable).

         2. Provide the necessary information manually, namely
         \code{par.est} (vector with estimated nugget, partial sill and shape parameters),
         \code{data} (used to estimate the semi-variogram model parameters),
         \code{max.dist} (semi-variogram parameter, numeric of length 1) and
         \code{nbins} (semi-variogram parameter, numeric of length 1).


         \strong{Filtered bootstrap method}:

         For the semi-variogram model parameter estimation, the weighted least squares method is used
         in order to make the numerical calculation possible for large sample sizes.
         A filter is set up within the bootstrapping process to remove all
         bootstrap estimates for which the estimation algorithm for the semi-variogram
         model parameters did not converge.

         The parameter standard errors are estimated using the generalized bootstrap
         method with check-based filtering.
         The semi-variogram structure from the given model is used to remove the
         spatial correlation structure within the original dataset. Then,
         classical bootstrap sampling with replacement is used to generate B
         bootstrap samples from the uncorrelated data.
         Each bootstrap sample inherits the correlation structure back and is used to estimate
         the nugget effect, partial sill and shape parameter for an exponential model.
         Within the bootstrap repetitions, a test is performed to check whether
         the estimated parameters lie within a probable range.
         If the total variance of the bootstrap model exceeds the empirical variance
         of the data times the treshold factor \eqn{\tau}, ie.
         \deqn{c_{0 b}^* + \sigma_{0 b}^{2*} > \tau  \widehat{Var(\mathbf{z})}}
         for the bth bootstrap estimate, it is discarded. Otherwise, it is saved.
         This procedure is performed until B bootstrap estimates have aggregated.
         The empirical standard deviation calculated from the bootstrap estimates provides the
         uncertainty estimate for each parameter.

         Details about the algorithm used to obtain standard errors for the parameters
         of the exponential semi-variogram model are provided in \insertCite{dyck_sv_ses;textual}{EgoCor}.

         \strong{Reproducibility}:

         In order to generate reproducible bootstrap results, set a random seed with the command \code{set.seed()}
         before using the \code{par.uncertainty} function.
}
\examples{
## Example 1
# Estimate semi-variogram models:
mods = vario.mod(data = birth, max.dist = c(1000,600), nbins = 13,
                 shinyresults = FALSE, windowplots = FALSE)
print(mods$infotable)

# Estimate the parameter standard errors:
\dontrun{
se.mod1 = par.uncertainty(vario.mod.output = mods, mod.nr = 1, B = 1000)
se.mod2 = par.uncertainty(vario.mod.output = mods, mod.nr = 2, B = 1000)
}

## Example 2
# Type in the specifications of the estimated exponential semi-variogram manually:
\dontrun{
se.mod1.man = par.uncertainty(par.est = c(1021.812, 225440.3, 0),
              data = birth, max.dist = 1000, nbins = 13, B = 1000)

se.mod2.man = par.uncertainty(par.est = c(121895.486, 107232.6, 63.68720),
              data = birth, max.dist = 600, nbins = 13, B = 1000)
}


}
\references{
\insertAllCited{}
}
