% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec_flag_non_region.R
\name{ec_flag_non_region}
\alias{ec_flag_non_region}
\title{Flag Occurrences those are in wrong ocean basins and are inland}
\usage{
ec_flag_non_region(
  direction,
  ocean,
  buffer = 50000,
  data,
  latitude = "decimalLatitude",
  longitude = "decimalLongitude"
)
}
\arguments{
\item{direction, }{values as "east" or "west". These values help to filter the shape files for east or west of select ocean (e.g. pacific) for both north and south hemisphere.}

\item{ocean, }{values such as "pacific" or "atlantic"}

\item{buffer, }{Its a certain buffer distance to consider if a data point is inland. Beyond this distance data points consider as bad data points. e.g. buffer <- 25000}

\item{data, }{Data table which has latitude and longitude information}

\item{latitude}{default set to "decimalLatitude"}

\item{longitude}{default set to "decimalLongitude"}
}
\value{
A new column with flagged values, 1 means bad records 0 means good record. Column name: flag_non_region
}
\description{
Flag Occurrences those are in wrong ocean basins and are inland
}
\examples{
\donttest{
direction <- "east"
buffer <- 25000
ocean <- "pacific"
data <- data.frame(
  species = "A",
  decimalLongitude = c(-120, -78, -110, -60, -75, -130, -10, 5),
  decimalLatitude = c(20, 34, 30, 10, 40, 25, 15, 35)
)
data$flag_non_region <- ec_flag_non_region(
  direction,
  ocean,
  buffer = 50000,
  data
)
}
}
