% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.fit.R
\name{network.fit}
\alias{network.fit}
\title{Traditional Fit Metrics for Networks}
\usage{
network.fit(network, n, S, ci = 0.95)
}
\arguments{
\item{network}{Matrix or data frame.
A p by p sqaure network matrix}

\item{n}{Numeric (length = 1).
Sample size}

\item{S}{Matrix or data frame.
A p by p sqaure zero-order correlation matrix corresponding
with the input \code{network}}

\item{ci}{Numeric (length = 1).
Confidence interval for RMSEA}
}
\value{
Returns a named vector of fit statistics
}
\description{
Computes several traditional fit metrics for networks including

\itemize{

\item chi-square (\eqn{\chi^2})

\item root mean square error of approximation (RMSEA) with confidence intervals

\item confirmatory fit index (CFI)

\item Tucker-Lewis inded (TLI)

\item standardized root mean residual (SRMR)

\item log-likelihood

\item Akaike's information criterion (AIC)

\item Bayesian information criterion (BIC)

}
}
\examples{
# Load data
wmt <- wmt2[,7:24]

# Obtain correlation matrix
S <- auto.correlate(wmt)

# EBICglasso (default for EGA functions)
glasso_network <- network.estimation(
  data = wmt, model = "glasso"
)

# Obtain fit (expects continuous variables!)
network.fit(network = glasso_network, n = nrow(wmt), S = S)
# Scaled metrics are not yet available for
# dichotomous or polytomous data!

}
\references{
Epskamp, S., Rhemtulla, M., & Borsboom, D. (2017).
Generalized network psychometrics: Combining network and latent variable models.
\emph{Psychometrika}, \emph{82}(4), 904–927.
}
\author{
Hudson Golino <hfg9s at virginia.edu> and Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
