% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proposeContinuous.R
\name{proposeContinuous}
\alias{proposeContinuous}
\title{Propose a new real hyperparameter value.}
\usage{
proposeContinuous(orig_beta, proposal_range, limit = 30)
}
\arguments{
\item{orig_beta}{Current value of the hyperparameter.}

\item{proposal_range}{Range for the new value.}

\item{limit}{Hard limit on the range.}
}
\value{
Returns a new uniformly random value within \code{proposal_range} of
\code{orig_beta} and limited by \code{limit}.
}
\description{
This function proposes a new real values hyperparameter for the information
sharing prior.
}
\examples{

# Previous parameter value
param = runif(1, 0, 1)

# Propose new value within range [0, 1], with proposal width 0.1
new.param = proposeContinuous(param, 0.1, 1)

}
\seealso{
\code{\link{ProposeDiscrete}}
}
\author{
Frank Dondelinger
}
