% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrate.R
\name{int_dia}
\alias{int_dia}
\title{Comprehensive Diagnostic Modeling Pipeline}
\usage{
int_dia(
  ...,
  model_names = NULL,
  tune = TRUE,
  n_estimators = 10,
  seed = 123,
  positive_label_value = 1,
  negative_label_value = 0,
  new_positive_label = "Positive",
  new_negative_label = "Negative"
)
}
\arguments{
\item{...}{Data frames for analysis. The first is the training dataset; all
subsequent arguments are test datasets.}

\item{model_names}{Character vector specifying which models to use.
If NULL (default), uses all registered models.}

\item{tune}{Logical, enable hyperparameter tuning. Default TRUE.}

\item{n_estimators}{Integer, number of bootstrap samples for bagging. Default 10.}

\item{seed}{Integer for reproducibility. Default 123.}

\item{positive_label_value}{Value representing positive class. Default 1.}

\item{negative_label_value}{Value representing negative class. Default 0.}

\item{new_positive_label}{Factor level name for positive class. Default "Positive".}

\item{new_negative_label}{Factor level name for negative class. Default "Negative".}
}
\value{
A list containing all_results, auroc_matrix, model_categories, dataset_names.
}
\description{
Executes a complete diagnostic modeling workflow including single
models, bagging, stacking, and voting ensembles across training and multiple
test datasets. Returns structured results with AUROC values for visualization.
}
