% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OpalSession.R
\name{dsIsReady,OpalSession-method}
\alias{dsIsReady,OpalSession-method}
\title{Get whether the remote R session is up and running}
\usage{
\S4method{dsIsReady}{OpalSession}(session)
}
\arguments{
\item{session}{\code{\link{OpalSession-class}} object.}
}
\value{
A logical indicating the readiness of the session.
}
\description{
Get the state of the remote R session and return TRUE if
the state is RUNNING. Always TRUE for synchronous
operations.
}
\examples{
\dontrun{
con <- dbConnect(DSOpal::Opal(), "server1",
  "administrator", "password", "https://opal-demo.obiba.org")
session <- dsSession(con, async = TRUE)
ready <- dsIsReady(session)
while (!ready) {
  Sys.sleep(1)
  ready <- dsIsReady(session)
  cat(".")
}
dsDisconnect(con)
}

}
