% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/difm.hyp.parm.R
\name{difm.hyp.parm}
\alias{difm.hyp.parm}
\title{Hyperparameters for DIFM}
\usage{
difm.hyp.parm(
  model.attributes,
  n.tau = 2.2,
  n.s2.tau = 0.1,
  n.sigma = 2.2,
  n.s2.sigma = 0.1,
  Hlist,
  Psi.size = 0.01
)
}
\arguments{
\item{model.attributes}{Model attributes from \code{difm.model.attributes}}

\item{n.tau}{Shape parameter for tau}

\item{n.s2.tau}{Rate parameter for tau}

\item{n.sigma}{Shape parameter for sigma squared}

\item{n.s2.sigma}{Rate parameter for sigma squared}

\item{Hlist}{Neighborhood matrix}

\item{Psi.size}{The magnitude of covariance for the evolution matrix}
}
\value{
A list of hyperparameters of tau, W, sigma, and theta.
}
\description{
Sets the hyperparameters to generate Gibbs sampler of DIFM
}
