#' generateSCM
#'
#' This function takes in an extracted set of features and a defined set of
#' components, and calculates the sum of the posterior probabilities for each
#' feature. This sum represents how much each component contributes to a sample
#' and corresponds to one column in the matrix.
#' 
#' @param feats List of features received from extractCopynumberFeatures
#' @param comps List of components modelled using fitModels
#' @param runName Name of the run used in file names, Default is ""
#' @param saveRes Whether or not to save the results, Default is FALSE
#' @param saveDir Where to save the results, Default is getwd()
#' @keywords sample by component matrix scm
#' @return Creates a sample by component matrix
#' @export
#' @examples
#' generateSCM(featsExp,compsExp)
generateSCM = function(feats, comps, runName = "",
                       saveRes=FALSE, saveDir=NULL){
   
   
   featureNames = names(feats)
   
   #Calls sumOfPosteriors for each of the features and cbinds them together
   scm = c()
   for (feat in featureNames){
      scm = cbind(scm, sumOfPosteriors(feats[[feat]],comps[[feat]],
                                                 feat))
   }
   
   # Sets the rownames and removes NA values
   rownames(scm) = unique(feats[[1]][,1])
   scm[is.na(scm)] = 0
   
   #Save the sample by component matrix
   if (saveRes){
      saveRDS(scm,file=paste0(saveDir,"/",runName,"_sample_component_matrix.rds"))
   }
   
   return(scm)
}
