% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caesar_enrichscore.R
\name{Cauchy.Combination}
\alias{Cauchy.Combination}
\title{Combine p-values Using the Cauchy Combination Method}
\usage{
Cauchy.Combination(pvals, weight = NULL)
}
\arguments{
\item{pvals}{A numeric vector of p-values to be combined. The p-values should be between 0 and 1.}

\item{weight}{A numeric vector of weights corresponding to the p-values. If \code{NULL}, equal weights are assigned to all p-values. Default is \code{NULL}.}
}
\value{
A single combined p-value.
}
\description{
This function combines multiple p-values using the Cauchy combination method. The method is particularly useful for combining dependent p-values and is known for being robust and powerful, especially in the context of small p-values. For details, see Liu and Xie (2020).
}
\examples{
# Example usage:
pvals <- c(0.01, 0.03, 0.05)
combined_pval <- Cauchy.Combination(pvals)
print(combined_pval)

}
\references{
Liu, Y., & Xie, J. (2020). Cauchy combination test: a powerful test with analytic p-value calculation under arbitrary dependency structures. Journal of the American Statistical Association, 115(529), 393-402.
}
